# -*- coding: utf-8 -*-

# Importation des bibliothèques utiles
import numpy as np
import matplotlib.pyplot as plt

## Filtre passe-bande d'ordre 2
# Fonction de transfert complexe H = H0/(1 + j Q (f/f0 - f0/f))

#---------------------------------------------------------------
f0 = 3000            # CHOISIR LA VALEUR DE f0 en Hz,
H0 = 1              # choisir la valeur de H0
Q = 10
#---------------------------------------------------------------

n = 2000

f = np.logspace(-2, 2, n+1)*f0          # n intervalles, entre 10^-2f0 et 10^2f0 ; n+1 valeurs

#Définition de la fonction de transfert
def H(H0, f0, Q, f):                   # ordre des variables arbitraire, à consserver à chaque appel de fonction
    return H0/(1 + 1j*Q*(f/f0-f0/f))


#Définition du diagramme de Bode
GdB = 20*np.log10(np.abs(H(H0, f0, Q, f)))
phi = np.angle(H(H0, f0, Q, f), deg=True)

#Tracé de GdB et phi en concordance de fréquence
plt.subplot(211)
plt.semilogx(f, GdB)
plt.legend(loc='lower center')
plt.title('Diagramme de Bode passe bande, H0 =' + str(H0) + ', f0 =' + str(f0) + ' Hz')
plt.ylabel('GdB')
plt.grid()

plt.subplot(212)
plt.semilogx(f, phi)
plt.legend(loc='center right')
plt.ylabel('phase (°)')
plt.xlabel('f (Hz)')
plt.grid()

plt.show()

